\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{dfletter}

\typeout{Document class dfletter <8 Apr 12> (P.D. Mininni), based on original document style `dfletter' <29 Sep 97> (modified by J.P. Garrahan from `tanletter' by R. De Luca).}

\DeclareOption*{\PassOptionsToClass{\CurrentOption}{letter}}
\ProcessOptions
\LoadClass{letter}
\usepackage{graphicx}

\raggedright
\setlength{\topmargin}{-1in}
\setlength{\oddsidemargin}{-.25in}
\setlength{\evensidemargin}{-.25in}
\setlength{\textwidth}{7in}
\setlength{\textheight}{7.2in}
\setlength{\headsep}{1in}
\setlength{\footskip}{1.625in}

\DeclareFixedFont{\boldfont}{OT1}{cmss}{bx}{n}{8}
\DeclareFixedFont{\regularfont}{OT1}{cmss}{m}{n}{8}
\DeclareFixedFont{\italicfont}{OT1}{cmr}{m}{it}{10}

\newcommand{\phonenum}{(54 11) 4576-3390}
\newcommand{\faxnum}{(54 11) 4576-3357}
\newcommand{\website}{http://www.df.uba.ar}

\newsavebox{\dfuba}
\newsavebox{\place}
\newsavebox{\footer}
\newsavebox{\dfubasmall}
\newsavebox{\mainaddress}
\newsavebox{\contactinfo}

\sbox{\dfuba}
     {\parbox[b]{160mm}
     {\vspace{.2in}\begin{center}\hspace{.8in}\scalebox{.3}{\includegraphics*{dflogo}}\end{center}}}

\sbox{\place}
     {\parbox[t]{6.5cm}
     {\setlength{\baselineskip}{9.2pt}{\boldfont Departamento de F\'{\i}sica J.J.~Giambiagi} \\
     {\regularfont Facultad de Ciencias Exactas y Naturales} \\
     {\regularfont Universidad de Buenos Aires}}}

\sbox{\mainaddress}
     {\parbox[t]{5.1cm}
     {\setlength{\baselineskip}{9.2pt}\regularfont{Pabell\'on I} \\
     \regularfont{Ciudad Universitaria} \\
     \regularfont{1428 Buenos Aires, Argentina}}}

\sbox{\contactinfo}
     {\parbox[t]{4.1cm}
     {\setlength{\baselineskip}{9.2pt}\regularfont{Tel.\hspace{5.1mm} \phonenum\\
	   Fax\hspace{5.6mm} \faxnum\\
	   Web\hspace{.5mm} \website}}}

\sbox{\footer}
     {\raisebox{1cm}{\parbox[t]{16.51cm}
     {\hspace{.25in}\usebox{\place} \usebox{\mainaddress} \usebox{\contactinfo}}}}

\renewcommand{\ps@headings}{
             \setlength{\headheight}{5cm}\setlength{\headsep}{1cm}
             \def\@oddfoot{\raisebox{55pt}[0pt]{\usebox{\footer}}}
             \let\@evenfoot\@oddfoot
             \def\@oddhead{\begin{minipage}[b]{11in}
	        {\begin{center}\hspace{-3.9in}\scalebox{.15}{\includegraphics*{dflogo}}\end{center}} 
                    {\slshape\headtoname{} \ignorespaces\toname , \@date
                    \hfil \pagename{} \thepage}\end{minipage}}
             \let\@evenhead\@oddhead}
%make sure the large header goes on the first page
\renewcommand{\ps@firstpage}{
	     \setlength{\headheight}{5cm}\setlength{\headsep}{1cm}
	     \renewcommand{\@oddhead}{\usebox{\dfuba}}
	     \renewcommand{\@oddfoot}{\raisebox{55pt}[0pt]{\usebox{\footer}}}}
\renewcommand*{\opening}[1]{
             \thispagestyle{firstpage}
             Buenos Aires, \@date\\
             \vspace{2\parskip}%
             {\raggedright \toname \\ \toaddress \par}
             \vspace{2\parskip}%
             {#1\par}
             \vspace{2\parskip}%
             \nobreak}
\renewcommand*{\signature}[1]{\def\fromsig{\italicfont #1}}

\providecommand{\@evenhead}{}\providecommand{\@oddhead}{}
\providecommand{\@evenfoot}{}\providecommand{\@oddfoot}{}

\pagestyle{headings}
